/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import ssh.BigInteger;
import ssh.MD5;
import ssh.SshCrypto;
import ssh.SshMisc;
import ssh.SshPacket;
import ssh.SshPacket1;
import ssh.SshPacket2;
import telnet.Telnet;

public class SshIO {
    private static MD5 md5 = new MD5();
    private String idstr = "";
    private String idstr_sent = "SSH/JTA (c) Marcus Meissner, Matthias L. Jugel\n";
    private SshCrypto crypto = null;
    String cipher_type;
    public static Random rnd = new Random();
    private int remotemajor;
    private int remoteminor;
    private int mymajor;
    private int myminor;
    private int useprotocol;
    public String login;
    public String password;
    public String dataToSend = null;
    public String hashHostKey = null;
    byte lastPacketSentType;
    private int phase = 0;
    private final int PHASE_INIT;
    private final int PHASE_SSH_RECEIVE_PACKET;
    BigInteger rsa_e;
    BigInteger rsa_n;
    private final byte SSH_MSG_DISCONNECT;
    private final byte SSH_SMSG_PUBLIC_KEY = (byte)2;
    private final byte SSH_CMSG_SESSION_KEY = (byte)3;
    private final byte SSH_CMSG_USER = (byte)4;
    private final byte SSH_CMSG_AUTH_PASSWORD = (byte)9;
    private final byte SSH_CMSG_REQUEST_PTY = (byte)10;
    private final byte SSH_CMSG_EXEC_SHELL = (byte)12;
    private final byte SSH_SMSG_SUCCESS = (byte)14;
    private final byte SSH_SMSG_FAILURE = (byte)15;
    private final byte SSH_CMSG_STDIN_DATA = (byte)16;
    private final byte SSH_SMSG_STDOUT_DATA = (byte)17;
    private final byte SSH_SMSG_STDERR_DATA = (byte)18;
    private final byte SSH_SMSG_EXITSTATUS = (byte)20;
    private final byte SSH_MSG_IGNORE = (byte)32;
    private final byte SSH_CMSG_EXIT_CONFIRMATION = (byte)33;
    private final byte SSH_MSG_DEBUG = (byte)36;
    private final byte SSH2_MSG_DISCONNECT;
    private final byte SSH2_MSG_IGNORE = (byte)2;
    private final byte SSH2_MSG_SERVICE_REQUEST = (byte)5;
    private final byte SSH2_MSG_SERVICE_ACCEPT = (byte)6;
    private final byte SSH2_MSG_KEXINIT = (byte)20;
    private final byte SSH2_MSG_NEWKEYS = (byte)21;
    private final byte SSH2_MSG_KEXDH_INIT = (byte)30;
    private final byte SSH2_MSG_KEXDH_REPLY = (byte)31;
    private String kexalgs;
    private String hostkeyalgs;
    private String encalgs2c;
    private String encalgc2s;
    private String macalgs2c;
    private String macalgc2s;
    private String compalgc2s;
    private String compalgs2c;
    private String langc2s;
    private String langs2;
    private int outgoingseq = 0;
    private int incomingseq = 0;
    private int SSH_CIPHER_NONE = 0;
    private int SSH_CIPHER_IDEA = 1;
    private int SSH_CIPHER_DES = 2;
    private int SSH_CIPHER_3DES = 3;
    private int SSH_CIPHER_TSS = 4;
    private int SSH_CIPHER_RC4 = 5;
    private int SSH_CIPHER_BLOWFISH = 6;
    private final int SSH_AUTH_RHOSTS;
    private final int SSH_AUTH_RSA;
    private final int SSH_AUTH_PASSWORD;
    private final int SSH_AUTH_RHOSTS_RSA;
    private boolean cansenddata = false;
    SshPacket currentpacket;
    byte[] one = new byte[1];

    public SshIO() {
        this.PHASE_INIT = 0;
        this.PHASE_SSH_RECEIVE_PACKET = 1;
        this.SSH_MSG_DISCONNECT = 1;
        this.SSH2_MSG_DISCONNECT = 1;
        this.SSH_AUTH_RHOSTS = 1;
        this.SSH_AUTH_RSA = 2;
        this.SSH_AUTH_PASSWORD = 3;
        this.SSH_AUTH_RHOSTS_RSA = 4;
    }

    public void write(byte[] byArray) throws IOException {
        if (Telnet.outputCount + byArray.length > Telnet.output.length) {
            byte[] byArray2 = new byte[Telnet.outputCount + byArray.length];
            System.arraycopy(Telnet.output, 0, byArray2, 0, Telnet.outputCount);
            Telnet.output = byArray2;
        }
        System.arraycopy(byArray, 0, Telnet.output, Telnet.outputCount, byArray.length);
        Telnet.outputCount += byArray.length;
    }

    private void write(byte by) throws IOException {
        this.one[0] = by;
        this.write(this.one);
    }

    public void disconnect() {
        this.login = "";
        this.password = "";
        this.phase = 0;
        this.crypto = null;
    }

    public synchronized void sendData(String string) throws IOException {
        this.dataToSend = this.dataToSend == null ? string : this.dataToSend + string;
        if (this.cansenddata) {
            this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
            this.dataToSend = null;
        }
    }

    public byte[] handleSSH(byte[] byArray) throws IOException {
        if (this.phase == 0) {
            int n = 0;
            while (n < byArray.length) {
                byte by = byArray[n++];
                this.idstr = this.idstr + (char)by;
                if (by != 10) continue;
                ++this.phase;
                this.remotemajor = Integer.parseInt(this.idstr.substring(4, 5));
                String string = this.idstr.substring(6, 8);
                if (!Character.isDigit(string.charAt(1))) {
                    string = string.substring(0, 1);
                }
                this.remoteminor = Integer.parseInt(string);
                if (this.remotemajor == 2) {
                    this.mymajor = 2;
                    this.myminor = 0;
                    this.useprotocol = 2;
                } else {
                    this.mymajor = 1;
                    this.myminor = 5;
                    this.useprotocol = 1;
                }
                this.idstr_sent = "SSH-" + this.mymajor + "." + this.myminor + "-" + this.idstr_sent;
                this.write(this.idstr_sent.getBytes());
                this.currentpacket = this.useprotocol == 2 ? new SshPacket2(null) : new SshPacket1(null);
            }
            if (n == byArray.length) {
                return "".getBytes();
            }
            return "Must not have left over data after PHASE_INIT!\n".getBytes();
        }
        String string = "";
        byte[] byArray2 = this.currentpacket.addPayload(byArray);
        if (this.currentpacket.isFinished()) {
            if (this.useprotocol == 1) {
                string = string + this.handlePacket1((SshPacket1)this.currentpacket);
                this.currentpacket = new SshPacket1(this.crypto);
            } else {
                string = string + this.handlePacket2((SshPacket2)this.currentpacket);
                this.currentpacket = new SshPacket2(this.crypto);
            }
        }
        while (byArray2 != null) {
            byArray2 = this.currentpacket.addPayload(byArray2);
            if (!this.currentpacket.isFinished()) continue;
            if (this.useprotocol == 1) {
                string = string + this.handlePacket1((SshPacket1)this.currentpacket);
                this.currentpacket = new SshPacket1(this.crypto);
                continue;
            }
            string = string + this.handlePacket2((SshPacket2)this.currentpacket);
            this.currentpacket = new SshPacket2(this.crypto);
        }
        return string.getBytes();
    }

    private String handlePacket2(SshPacket2 sshPacket2) throws IOException {
        switch (sshPacket2.getType()) {
            case 2: {
                break;
            }
            case 1: {
                int n = sshPacket2.getInt32();
                String string = sshPacket2.getString();
                return "\nSSH2 disconnect: " + string + "\n";
            }
            case 21: {
                this.sendPacket2(new SshPacket2(21));
                byte[] byArray = new byte[16];
                this.crypto = new SshCrypto(this.cipher_type, byArray);
                SshPacket2 sshPacket22 = new SshPacket2(5);
                sshPacket22.putString("ssh-userauth");
                this.sendPacket2(sshPacket22);
                break;
            }
            case 6: {
                break;
            }
            case 20: {
                byte[] byArray = sshPacket2.getBytes(16);
                String string = sshPacket2.getString();
                String string2 = sshPacket2.getString();
                String string3 = sshPacket2.getString();
                String string4 = sshPacket2.getString();
                String string5 = sshPacket2.getString();
                String string6 = sshPacket2.getString();
                String string7 = sshPacket2.getString();
                String string8 = sshPacket2.getString();
                String string9 = sshPacket2.getString();
                String string10 = sshPacket2.getString();
                byte[] byArray2 = sshPacket2.getBytes(1);
                SshPacket2 sshPacket23 = new SshPacket2(20);
                byte[] byArray3 = new byte[16];
                sshPacket23.putBytes(byArray3);
                sshPacket23.putString("diffie-hellman-group1-sha1");
                sshPacket23.putString("ssh-rsa");
                this.cipher_type = "NONE";
                String string11 = "none";
                sshPacket23.putString("none");
                sshPacket23.putString("none");
                sshPacket23.putString("hmac-md5");
                sshPacket23.putString("hmac-md5");
                sshPacket23.putString("none");
                sshPacket23.putString("none");
                sshPacket23.putString("");
                sshPacket23.putString("");
                sshPacket23.putByte((byte)0);
                sshPacket23.putInt32(0);
                this.sendPacket2(sshPacket23);
                sshPacket23 = new SshPacket2(30);
                sshPacket23.putMpInt(BigInteger.valueOf(-559038737L));
                this.sendPacket2(sshPacket23);
                break;
            }
            case 31: {
                int n = sshPacket2.getInt32();
                String string = sshPacket2.getString();
                if (!string.equals("ssh-rsa")) {
                    return "\n\rUnsupported kexdh algorithm " + string + "!\n\r";
                }
                this.rsa_e = sshPacket2.getMpInt();
                this.rsa_n = sshPacket2.getMpInt();
                String string12 = "\n\rSSH-RSA (" + this.rsa_n + "," + this.rsa_e + ")\n\r";
                BigInteger bigInteger = sshPacket2.getMpInt();
                string12 = string12 + "DH Server Pub: " + bigInteger + "\n\r";
                int n2 = sshPacket2.getInt32();
                String string13 = sshPacket2.getString();
                string12 = string12 + "Signature: ktype is " + string13 + "\r\n";
                byte[] byArray = sshPacket2.getBytes(sshPacket2.getInt32());
                return string12;
            }
            default: {
                return "SSH2: handlePacket2 Unknown type " + sshPacket2.getType();
            }
        }
        return "";
    }

    private String handlePacket1(SshPacket1 sshPacket1) throws IOException {
        switch (sshPacket1.getType()) {
            case 32: {
                return "";
            }
            case 1: {
                String string = sshPacket1.getString();
                this.disconnect();
                return string;
            }
            case 2: {
                byte[] byArray = sshPacket1.getBytes(8);
                byte[] byArray2 = sshPacket1.getBytes(4);
                byte[] byArray3 = sshPacket1.getMpInt();
                byte[] byArray4 = sshPacket1.getMpInt();
                byte[] byArray5 = sshPacket1.getBytes(4);
                byte[] byArray6 = sshPacket1.getMpInt();
                byte[] byArray7 = sshPacket1.getMpInt();
                byte[] byArray8 = sshPacket1.getBytes(4);
                byte[] byArray9 = sshPacket1.getBytes(4);
                byte[] byArray10 = sshPacket1.getBytes(4);
                String string = this.Send_SSH_CMSG_SESSION_KEY(byArray, byArray4, byArray7, byArray9, byArray3, byArray6);
                if (string != null) {
                    return string;
                }
                if (this.hashHostKey == null || this.hashHostKey.compareTo("") == 0) break;
                byte[] byArray11 = md5.digest(byArray7);
                String string2 = "";
                int n = 0;
                while (n < byArray11.length) {
                    String string3 = "";
                    int[] nArray = new int[]{(byArray11[n] & 0xF0) >> 4, byArray11[n] & 0xF};
                    int n2 = 0;
                    while (n2 < 1) {
                        switch (nArray[n2]) {
                            case 10: {
                                string3 = string3 + "a";
                                break;
                            }
                            case 11: {
                                string3 = string3 + "b";
                                break;
                            }
                            case 12: {
                                string3 = string3 + "c";
                                break;
                            }
                            case 13: {
                                string3 = string3 + "d";
                                break;
                            }
                            case 14: {
                                string3 = string3 + "e";
                                break;
                            }
                            case 15: {
                                string3 = string3 + "f";
                                break;
                            }
                            default: {
                                string3 = string3 + String.valueOf(nArray[n2]);
                            }
                        }
                        ++n2;
                    }
                    string2 = string2 + string3;
                    ++n;
                }
                if (string2.compareTo(this.hashHostKey) == 0) break;
                this.password = "";
                this.login = "";
                return "\nHash value of the host key not correct \r\n";
            }
            case 14: {
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nEmpty password login.\r\n";
                }
                if (this.lastPacketSentType == 9) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nLogin & password accepted\r\n";
                }
                if (this.lastPacketSentType == 10) {
                    this.cansenddata = true;
                    if (this.dataToSend != null) {
                        this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
                        this.dataToSend = null;
                    }
                    this.Send_SSH_CMSG_EXEC_SHELL();
                    break;
                }
                if (this.lastPacketSentType != 12) break;
                break;
            }
            case 15: {
                if (this.lastPacketSentType == 9) {
                    this.disconnect();
                    return "\nLogin & password not accepted\r\n";
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                return sshPacket1.getString();
            }
            case 18: {
                String string = "Error : " + sshPacket1.getString();
                return string;
            }
            case 20: {
                int n = sshPacket1.getInt32();
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
                this.disconnect();
                break;
            }
            case 36: {
                String string = sshPacket1.getString();
                return "";
            }
        }
        return "";
    }

    private void sendPacket1(SshPacket1 sshPacket1) throws IOException {
        this.write(sshPacket1.getPayLoad(this.crypto));
        this.lastPacketSentType = sshPacket1.getType();
    }

    private void sendPacket2(SshPacket2 sshPacket2) throws IOException {
        this.write(sshPacket2.getPayLoad(this.crypto, this.outgoingseq));
        ++this.outgoingseq;
        this.lastPacketSentType = sshPacket2.getType();
    }

    private String Send_SSH_CMSG_SESSION_KEY(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws IOException {
        byte by;
        byte[] byArray7 = new byte[byArray3.length + byArray2.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray7, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray7, byArray3.length + byArray2.length, byArray.length);
        byte[] byArray8 = md5.digest(byArray7);
        if ((byArray4[3] & (byte)(1 << this.SSH_CIPHER_BLOWFISH)) != 0) {
            by = (byte)this.SSH_CIPHER_BLOWFISH;
            this.cipher_type = "Blowfish";
        } else if ((byArray4[3] & 1 << this.SSH_CIPHER_IDEA) != 0) {
            by = (byte)this.SSH_CIPHER_IDEA;
            this.cipher_type = "IDEA";
        } else if ((byArray4[3] & 1 << this.SSH_CIPHER_3DES) != 0) {
            by = (byte)this.SSH_CIPHER_3DES;
            this.cipher_type = "DES3";
        } else if ((byArray4[3] & 1 << this.SSH_CIPHER_DES) != 0) {
            by = (byte)this.SSH_CIPHER_DES;
            this.cipher_type = "DES";
        } else {
            this.disconnect();
            return "\rRemote server does not support IDEA/Blowfish/3DES blockcipher, closing connection.\r\n";
        }
        byte[] byArray9 = new byte[16];
        byte[] byArray10 = new byte[16];
        byArray9 = md5.digest(("" + rnd.nextLong() * new Date().getTime()).getBytes());
        byArray10 = byArray9;
        byArray9 = md5.digest(SshMisc.addArrayOfBytes(md5.digest((this.password + this.login).getBytes()), byArray9));
        byArray10 = md5.digest(SshMisc.addArrayOfBytes(md5.digest((this.password + this.login).getBytes()), byArray10));
        byte[] byArray11 = SshMisc.addArrayOfBytes(byArray9, byArray10);
        byte[] byArray12 = SshMisc.XORArrayOfBytes(byArray9, byArray8);
        byArray12 = SshMisc.addArrayOfBytes(byArray12, byArray10);
        byte[] byArray13 = SshCrypto.encrypteRSAPkcs1Twice(byArray12, byArray5, byArray2, byArray6, byArray3);
        int n = 0;
        SshPacket1 sshPacket1 = new SshPacket1(3);
        sshPacket1.putByte(by);
        sshPacket1.putBytes(byArray);
        sshPacket1.putBytes(byArray13);
        sshPacket1.putInt32(n);
        this.sendPacket1(sshPacket1);
        this.crypto = new SshCrypto(this.cipher_type, byArray11);
        return "";
    }

    private String Send_SSH_CMSG_USER() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(4);
        sshPacket1.putString(this.login);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(9);
        sshPacket1.putString(this.password);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(12);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_STDIN_DATA(String string) throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(16);
        sshPacket1.putString(string);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(10);
        sshPacket1.putString(Telnet.emulation.getTerminalID());
        sshPacket1.putInt32(Telnet.emulation.height);
        sshPacket1.putInt32(Telnet.emulation.width);
        sshPacket1.putInt32(0);
        sshPacket1.putInt32(0);
        sshPacket1.putByte((byte)0);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(33);
        this.sendPacket1(sshPacket1);
        return "";
    }
}

