/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import ssh.MPN;

public class BigInteger {
    private transient int ival;
    private transient int[] words;
    private static final int minFixNum = -100;
    private static final int maxFixNum = 1024;
    private static final int numFixNum = 1125;
    private static final BigInteger[] smallFixNums = new BigInteger[1125];
    public static final BigInteger ZERO;
    public static final BigInteger ONE;

    private BigInteger() {
    }

    private BigInteger(int n) {
        this.ival = n;
    }

    public BigInteger(byte[] byArray) {
        this.words = BigInteger.byteArrayToIntArray(byArray, 0);
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    public static BigInteger valueOf(long l) {
        if (l >= -100L && l <= 1024L) {
            return smallFixNums[(int)l - -100];
        }
        int n = (int)l;
        if ((long)n == l) {
            return new BigInteger(n);
        }
        BigInteger bigInteger = BigInteger.alloc(2);
        bigInteger.ival = 2;
        bigInteger.words[0] = n;
        bigInteger.words[1] = (int)(l >> 32);
        return bigInteger;
    }

    private static BigInteger make(int[] nArray, int n) {
        if (nArray == null) {
            return BigInteger.valueOf(n);
        }
        if ((n = BigInteger.wordsNeeded(nArray, n)) <= 1) {
            return n == 0 ? ZERO : BigInteger.valueOf(nArray[0]);
        }
        BigInteger bigInteger = new BigInteger();
        bigInteger.words = nArray;
        bigInteger.ival = n;
        return bigInteger;
    }

    private static int[] byteArrayToIntArray(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length / 4 + 1];
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        int n5 = byArray.length % 4;
        while (n5 > 0) {
            n4 = n4 << 8 | byArray[n3] & 0xFF;
            --n5;
            ++n3;
        }
        nArray[--n2] = n4;
        while (n2 > 0) {
            nArray[--n2] = byArray[n3++] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
        return nArray;
    }

    private static BigInteger alloc(int n) {
        BigInteger bigInteger = new BigInteger();
        if (n > 1) {
            bigInteger.words = new int[n];
        }
        return bigInteger;
    }

    private void realloc(int n) {
        if (n == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < n || this.words.length > n + 2) {
            int[] nArray = new int[n];
            if (this.words == null) {
                nArray[0] = this.ival;
                this.ival = 1;
            } else {
                if (n < this.ival) {
                    this.ival = n;
                }
                System.arraycopy(this.words, 0, nArray, 0, this.ival);
            }
            this.words = nArray;
        }
    }

    private static int compareTo(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        if (bigInteger.words == null && bigInteger2.words == null) {
            return bigInteger.ival < bigInteger2.ival ? -1 : (bigInteger.ival > bigInteger2.ival ? 1 : 0);
        }
        int n2 = bigInteger.words == null ? 1 : bigInteger.ival;
        int n3 = n = bigInteger2.words == null ? 1 : bigInteger2.ival;
        if (n2 != n) {
            return n2 > n ? 1 : -1;
        }
        return MPN.cmp(bigInteger.words, bigInteger2.words, n2);
    }

    public int compareTo(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger);
    }

    private final boolean isZero() {
        return this.words == null && this.ival == 0;
    }

    private final boolean isOne() {
        return this.words == null && this.ival == 1;
    }

    /*
     * Unable to fully structure code
     */
    private static int wordsNeeded(int[] var0, int var1_1) {
        block3: {
            var2_2 = var1_1;
            if (var2_2 <= 0) break block3;
            if ((var3_3 = var0[--var2_2]) != -1) ** GOTO lbl11
            while (var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) < 0) {
                --var2_2;
                if (var3_3 == -1) {
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl11:
                // 2 sources

                ** while (var3_3 == 0 && var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) >= 0)
            }
        }
        return var2_2 + 1;
    }

    private BigInteger canonicalize() {
        if (this.words != null && (this.ival = BigInteger.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    private static final BigInteger add(int n, int n2) {
        return BigInteger.valueOf((long)n + (long)n2);
    }

    private static BigInteger add(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger.ival, n);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setAdd(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    private void setAdd(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            this.set((long)bigInteger.ival + (long)n);
            return;
        }
        int n2 = bigInteger.ival;
        this.realloc(n2 + 1);
        long l = n;
        int n3 = 0;
        while (n3 < n2) {
            this.words[n3] = (int)(l += (long)bigInteger.words[n3] & 0xFFFFFFFFL);
            l >>= 32;
            ++n3;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            --l;
        }
        this.words[n2] = (int)l;
        this.ival = BigInteger.wordsNeeded(this.words, n2 + 1);
    }

    private final void set(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.ival = n;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = n;
            this.words[1] = (int)(l >> 32);
            this.ival = 2;
        }
    }

    private final void set(int[] nArray, int n) {
        this.ival = n;
        this.words = nArray;
    }

    private final void set(BigInteger bigInteger) {
        if (bigInteger.words == null) {
            this.set(bigInteger.ival);
        } else if (this != bigInteger) {
            this.realloc(bigInteger.ival);
            System.arraycopy(bigInteger.words, 0, this.words, 0, bigInteger.ival);
            this.ival = bigInteger.ival;
        }
    }

    private static BigInteger add(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        BigInteger bigInteger3;
        if (bigInteger.words == null && bigInteger2.words == null) {
            return BigInteger.valueOf((long)n * (long)bigInteger2.ival + (long)bigInteger.ival);
        }
        if (n != 1) {
            bigInteger2 = BigInteger.times(bigInteger2, BigInteger.valueOf(n));
        }
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger2, bigInteger.ival);
        }
        if (bigInteger2.words == null) {
            return BigInteger.add(bigInteger, bigInteger2.ival);
        }
        if (bigInteger2.ival > bigInteger.ival) {
            bigInteger3 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger3;
        }
        bigInteger3 = BigInteger.alloc(bigInteger.ival + 1);
        int n2 = bigInteger2.ival;
        long l = MPN.add_n(bigInteger3.words, bigInteger.words, bigInteger2.words, n2);
        long l2 = bigInteger2.words[n2 - 1] < 0 ? 0xFFFFFFFFL : 0L;
        while (n2 < bigInteger.ival) {
            bigInteger3.words[n2] = (int)(l += ((long)bigInteger.words[n2] & 0xFFFFFFFFL) + l2);
            l >>>= 32;
            ++n2;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            --l2;
        }
        bigInteger3.words[n2] = (int)(l + l2);
        bigInteger3.ival = n2 + 1;
        return bigInteger3.canonicalize();
    }

    private static final BigInteger times(BigInteger bigInteger, int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return bigInteger;
        }
        int[] nArray = bigInteger.words;
        int n2 = bigInteger.ival;
        if (nArray == null) {
            return BigInteger.valueOf((long)n2 * (long)n);
        }
        BigInteger bigInteger2 = BigInteger.alloc(n2 + 1);
        bigInteger2.words[n2] = MPN.mul_1(bigInteger2.words, nArray, n2, n);
        bigInteger2.ival = n2 + 1;
        return bigInteger2.canonicalize();
    }

    private static final BigInteger times(BigInteger bigInteger, BigInteger bigInteger2) {
        Object object;
        if (bigInteger2.words == null) {
            return BigInteger.times(bigInteger, bigInteger2.ival);
        }
        if (bigInteger.words == null) {
            return BigInteger.times(bigInteger2, bigInteger.ival);
        }
        int n = bigInteger.ival;
        int n2 = bigInteger2.ival;
        int[] nArray = bigInteger.words;
        int[] nArray2 = bigInteger2.words;
        if (n < n2) {
            object = nArray;
            nArray = nArray2;
            nArray2 = object;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        object = BigInteger.alloc(n + n2);
        MPN.mul(((BigInteger)object).words, nArray, n, nArray2, n2);
        ((BigInteger)object).ival = n + n2;
        return super.canonicalize();
    }

    private static void divide(long l, long l2, BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            bl2 = true;
            if (l == Long.MIN_VALUE) {
                BigInteger.divide(BigInteger.valueOf(l), BigInteger.valueOf(l2), bigInteger, bigInteger2);
                return;
            }
            l = -l;
        } else {
            bl2 = false;
        }
        if (l2 < 0L) {
            bl = true;
            if (l2 == Long.MIN_VALUE) {
                BigInteger.divide(BigInteger.valueOf(l), BigInteger.valueOf(l2), bigInteger, bigInteger2);
                return;
            }
            l2 = -l2;
        } else {
            bl = false;
        }
        long l3 = l / l2;
        long l4 = l % l2;
        boolean bl3 = bl2 ^ bl;
        boolean bl4 = false;
        if (l4 != 0L && bl3) {
            bl4 = true;
        }
        if (bigInteger != null) {
            if (bl4) {
                ++l3;
            }
            if (bl3) {
                l3 = -l3;
            }
            bigInteger.set(l3);
        }
        if (bigInteger2 != null) {
            if (bl4) {
                l4 = l2 - l4;
                boolean bl5 = bl2 = !bl2;
            }
            if (bl2) {
                l4 = -l4;
            }
            bigInteger2.set(l4);
        }
    }

    private static void divide(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        int n;
        int n2;
        if (!(bigInteger.words != null && bigInteger.ival > 2 || bigInteger2.words != null && bigInteger2.ival > 2)) {
            long l = bigInteger.longValue();
            long l2 = bigInteger2.longValue();
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                BigInteger.divide(l, l2, bigInteger3, bigInteger4);
                return;
            }
        }
        int n3 = bigInteger2.words == null ? 1 : bigInteger2.ival;
        int[] nArray = new int[n3];
        bigInteger2.getAbsolute(nArray);
        while (n3 > 1 && nArray[n3 - 1] == 0) {
            --n3;
        }
        int n4 = bigInteger.words == null ? 1 : bigInteger.ival;
        int[] nArray2 = new int[n4 + 2];
        bigInteger.getAbsolute(nArray2);
        while (n4 > 1 && nArray2[n4 - 1] == 0) {
            --n4;
        }
        int n5 = MPN.cmp(nArray2, n4, nArray, n3);
        if (n5 < 0) {
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n2 = n4;
            n = 1;
            nArray2[0] = 0;
        } else if (n5 == 0) {
            nArray2[0] = 1;
            n = 1;
            nArray[0] = 0;
            n2 = 1;
        } else if (n3 == 1) {
            n = n4;
            if (nArray[0] == 1 && nArray2[n4 - 1] < 0) {
                ++n;
            }
            n2 = 1;
            nArray[0] = MPN.divmod_1(nArray2, nArray2, n4, nArray[0]);
        } else {
            int n6;
            int n7 = MPN.count_leading_zeros(nArray[n3 - 1]);
            if (n7 != 0) {
                MPN.lshift(nArray, 0, nArray, n3, n7);
                n6 = MPN.lshift(nArray2, 0, nArray2, n4, n7);
                nArray2[n4++] = n6;
            }
            if (n4 == n3) {
                nArray2[n4++] = 0;
            }
            MPN.divide(nArray2, n4, nArray, n3);
            n2 = n3;
            MPN.rshift0(nArray, nArray2, 0, n2, n7);
            n = n4 + 1 - n3;
            if (bigInteger3 != null) {
                n6 = 0;
                while (n6 < n) {
                    nArray2[n6] = nArray2[n6 + n3];
                    ++n6;
                }
            }
        }
        if (nArray[n2 - 1] < 0) {
            nArray[n2] = 0;
            ++n2;
        }
        if (bigInteger3 != null) {
            bigInteger3.set(nArray2, n);
        }
        if (bigInteger4 != null) {
            bigInteger4.set(nArray, n2);
        }
    }

    public BigInteger mod(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger2);
        return bigInteger2.canonicalize();
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.isOne()) {
            return this.mod(bigInteger2);
        }
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = this;
        BigInteger bigInteger5 = bigInteger;
        while (!bigInteger5.isZero()) {
            if (bigInteger5.and(ONE).isOne()) {
                bigInteger3 = BigInteger.times(bigInteger3, bigInteger4).mod(bigInteger2);
            }
            bigInteger5 = BigInteger.valueOf(bigInteger5.ival >> 1);
            bigInteger4 = BigInteger.times(bigInteger4, bigInteger4).mod(bigInteger2);
        }
        return bigInteger3;
    }

    public long longValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    private void getAbsolute(int[] nArray) {
        int n;
        int n2;
        if (this.words == null) {
            n2 = 1;
            nArray[0] = this.ival;
        } else {
            n = n2 = this.ival;
            while (--n >= 0) {
                nArray[n] = this.words[n];
            }
        }
        n = nArray.length;
        while (--n > n2) {
            nArray[n] = 0;
        }
    }

    public int bitLength() {
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public byte[] toByteArray() {
        int n;
        byte[] byArray = new byte[(this.bitLength() + 1 + 7) / 8];
        int n2 = byArray.length;
        int n3 = 0;
        while (n2 > 4) {
            n = this.words[n3++];
            int n4 = 4;
            while (n4 > 0) {
                byArray[--n2] = (byte)n;
                --n4;
                n >>= 8;
            }
        }
        n = this.words == null ? this.ival : this.words[n3];
        while (n2 > 0) {
            byArray[--n2] = (byte)n;
            n >>= 8;
        }
        return byArray;
    }

    private static BigInteger and(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.valueOf(bigInteger.ival & n);
        }
        if (n >= 0) {
            return BigInteger.valueOf(bigInteger.words[0] & n);
        }
        int n2 = bigInteger.ival;
        int[] nArray = new int[n2];
        nArray[0] = bigInteger.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = bigInteger.words[n2];
        }
        return BigInteger.make(nArray, bigInteger.ival);
    }

    public BigInteger and(BigInteger bigInteger) {
        if (bigInteger.words == null) {
            return BigInteger.and(this, bigInteger.ival);
        }
        if (this.words == null) {
            return BigInteger.and(bigInteger, this.ival);
        }
        BigInteger bigInteger2 = this;
        if (this.ival < bigInteger.ival) {
            BigInteger bigInteger3 = this;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger3;
        }
        int n = bigInteger.ival;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < bigInteger.ival) {
            nArray[n2] = bigInteger2.words[n2] & bigInteger.words[n2];
            ++n2;
        }
        while (n2 < n) {
            nArray[n2] = bigInteger2.words[n2];
            ++n2;
        }
        return BigInteger.make(nArray, n);
    }

    static {
        int n = 1125;
        while (--n >= 0) {
            BigInteger.smallFixNums[n] = new BigInteger(n + -100);
        }
        ZERO = smallFixNums[100];
        ONE = smallFixNums[101];
    }
}

