/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class TransactionList
extends List
implements CommandListener {
    String[] recStores;
    Alert confirm;
    Alert confirmAll;
    Command confYes;
    Command confNo;
    Command edit;
    Command delete;
    Command deleteAll;
    Command back;
    Command sync;

    public TransactionList() {
        super("Transaction list", 3);
        this.confirm = new Alert("Delete", "Do you want to delete the selected transaction?", Cash2ME.main.question, AlertType.CONFIRMATION);
        this.confirmAll = new Alert("Delete all", "Do you want to delete ALL transactions?", Cash2ME.main.question, AlertType.CONFIRMATION);
        this.confYes = new Command("Yes", 4, 1);
        this.confNo = new Command("No", 3, 2);
        this.edit = new Command("Edit", 4, 1);
        this.back = new Command("Back", 2, 1);
        this.delete = new Command("Delete", 8, 2);
        this.deleteAll = new Command("Delete All", 8, 1);
        this.sync = new Command("Sync", 8, 3);
        this.addCommand(this.edit);
        this.addCommand(this.back);
        this.addCommand(this.deleteAll);
        this.addCommand(this.delete);
        this.addCommand(this.sync);
        this.confirm.setCommandListener((CommandListener)this);
        this.confirmAll.setCommandListener((CommandListener)this);
        this.confirm.addCommand(this.confNo);
        this.confirm.addCommand(this.confYes);
        this.confirmAll.addCommand(this.confNo);
        this.confirmAll.addCommand(this.confYes);
        this.setCommandListener(this);
    }

    public void setCurrent() {
        this.load();
        Cash2ME.display.setCurrent((Displayable)this);
    }

    public void load() {
        this.deleteAll();
        this.recStores = Cash2ME.main.rms.listRecStores();
        String recordStr = "";
        if (this.recStores != null) {
            int i = 0;
            while (i < this.recStores.length) {
                String desc;
                Cash2ME.main.rms.openRecStore(this.recStores[i]);
                Image icon = null;
                String spend_receive_index = Cash2ME.main.rms.readRecord(7);
                String spend_receive_text = "";
                if (spend_receive_index.equals("0")) {
                    icon = Cash2ME.main.spend;
                    spend_receive_text = "-";
                } else if (spend_receive_index.equals("1")) {
                    icon = Cash2ME.main.receive;
                }
                if (!Cash2ME.main.options.getShowIcons()) {
                    icon = null;
                }
                recordStr = String.valueOf(Cash2ME.main.rms.readRecord(2)) + ": " + Cash2ME.main.rms.readRecord(6) + "\n" + spend_receive_text + Cash2ME.main.rms.readRecord(9);
                if (Cash2ME.main.options.getShowDescription() && (desc = Cash2ME.main.rms.readRecord(10)) != null && desc.length() > 0) {
                    recordStr = String.valueOf(recordStr) + " [" + desc + "]";
                }
                this.append(recordStr, icon);
                Cash2ME.main.rms.closeRecStore();
                ++i;
            }
        }
    }

    public void deleteRecs() {
        Cash2ME.main.rms.deleteRecStore(this.recStores[this.getSelectedIndex()]);
        this.setCurrent();
    }

    public void deleteRecsAsk() {
        if (this.recStores.length > 0) {
            Cash2ME.display.setCurrent((Displayable)this.confirm);
        }
    }

    public void deleteAllRecs() {
        if (this.recStores != null) {
            int i = 0;
            while (i < this.recStores.length) {
                Cash2ME.main.rms.deleteRecStore(this.recStores[i]);
                ++i;
            }
        }
        this.setCurrent();
    }

    public void deleteAllRecsAsk() {
        if (this.recStores.length > 0) {
            Cash2ME.display.setCurrent((Displayable)this.confirmAll);
        } else {
            this.setCurrent();
        }
    }

    public void edit() {
        Cash2ME.main.transaction.load(this.recStores[this.getSelectedIndex()]);
        Cash2ME.main.transaction.setCurrent();
    }

    public void sync() {
        Cash2ME.main.sync.setCurrent();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.back) {
            Cash2ME.main.transaction.setCurrent();
        } else if (c == this.confNo) {
            this.setCurrent();
        } else if (c == this.deleteAll) {
            this.deleteAllRecsAsk();
        } else if (c == this.confYes && d == this.confirmAll) {
            this.deleteAllRecs();
        } else if (c == this.delete) {
            this.deleteRecsAsk();
        } else if (c == this.confYes && d == this.confirm) {
            this.deleteRecs();
        } else if (c == this.edit) {
            this.edit();
        } else if (c == this.sync) {
            this.sync();
        }
    }
}

