/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class Transaction
extends Form
implements CommandListener {
    static final int DATE_INDEX = 1;
    static final int DATE_STRING_INDEX = 2;
    static final int CAT_FROM_INDEX = 3;
    static final int CAT_FROM_DESC_INDEX = 4;
    static final int CAT_TO_INDEX = 5;
    static final int CAT_TO_DESC_INDEX = 6;
    static final int SPEND_RECEIVE_INDEX = 7;
    static final int SPEND_RECEIVE_DESC_INDEX = 8;
    static final int AMMOUNT_INDEX = 9;
    static final int DESC_INDEX = 10;
    DateField date = new DateField("Date", 1);
    ChoiceGroup categoryFrom;
    ChoiceGroup categoryTo;
    ChoiceGroup spendOrReceive;
    TextField ammount;
    TextField description;
    String curRec = null;
    Command ok;
    Command exit;
    Command list;
    Command categories;
    Command options;
    Command about;

    public Transaction() {
        super("Transaction");
        this.date.setDate(new Date());
        this.categoryFrom = new ChoiceGroup("From", 4, Data.getCategoryes(), null);
        this.categoryTo = new ChoiceGroup("To", 4, Data.getCategoryes(), null);
        this.spendOrReceive = new ChoiceGroup("", 4, new String[]{"Spend", "Receive"}, null);
        this.ammount = new TextField("Ammount", "", 20, 5);
        this.description = new TextField("Description", "", 255, 0);
        this.ok = new Command("Save", 4, 1);
        this.exit = new Command("Exit", 7, 1);
        this.list = new Command("List Transactions", 8, 4);
        this.categories = new Command("Categories", 8, 3);
        this.options = new Command("Options", 8, 2);
        this.about = new Command("About", 8, 1);
        this.append((Item)this.date);
        this.append((Item)this.categoryFrom);
        this.append((Item)this.categoryTo);
        this.append((Item)this.spendOrReceive);
        this.append((Item)this.ammount);
        this.append((Item)this.description);
        this.addCommand(this.ok);
        this.addCommand(this.exit);
        this.addCommand(this.about);
        this.addCommand(this.options);
        this.addCommand(this.list);
        this.addCommand(this.categories);
        this.setCommandListener(this);
    }

    public void setCurrent() {
        Cash2ME.display.setCurrent((Displayable)this);
    }

    private void clear() {
        this.date.setDate(new Date());
        this.ammount.setString("");
        this.description.setString("");
        this.curRec = null;
    }

    public void reloadCategories() {
        this.categoryFrom.deleteAll();
        this.categoryTo.deleteAll();
        String[] cat = Data.getCategoryes();
        int i = 0;
        while (i < cat.length) {
            this.categoryFrom.append(cat[i], null);
            this.categoryTo.append(cat[i], null);
            ++i;
        }
    }

    private void save() {
        String recordStroneName;
        if (this.ammount.getString().length() == 0) {
            Alert a = new Alert("Alert", "Insert an ammount", Cash2ME.main.edit, AlertType.WARNING);
            a.setTimeout(-2);
            Cash2ME.display.setCurrent((Displayable)a);
            return;
        }
        if (this.curRec != null) {
            Cash2ME.main.rms.deleteRecStore(this.curRec);
        }
        if (Cash2ME.main.rms.openRecStore(recordStroneName = Cash2ME.main.rms.freeRecStoreName())) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.date.getDate());
            String dateString = String.valueOf(String.valueOf(c.get(5))) + "." + String.valueOf(c.get(2) + 1) + "." + String.valueOf(c.get(1));
            Cash2ME.main.rms.writeRecord(String.valueOf(this.date.getDate().getTime()));
            Cash2ME.main.rms.writeRecord(dateString);
            Cash2ME.main.rms.writeRecord(String.valueOf(this.categoryFrom.getSelectedIndex()));
            Cash2ME.main.rms.writeRecord(String.valueOf(this.categoryFrom.getString(this.categoryFrom.getSelectedIndex())));
            Cash2ME.main.rms.writeRecord(String.valueOf(this.categoryTo.getSelectedIndex()));
            Cash2ME.main.rms.writeRecord(String.valueOf(this.categoryTo.getString(this.categoryTo.getSelectedIndex())));
            Cash2ME.main.rms.writeRecord(String.valueOf(this.spendOrReceive.getSelectedIndex()));
            Cash2ME.main.rms.writeRecord(String.valueOf(this.spendOrReceive.getString(this.spendOrReceive.getSelectedIndex())));
            int i = this.ammount.getString().indexOf(".");
            if (i == -1) {
                this.ammount.setString(String.valueOf(this.ammount.getString()) + ".00");
            } else {
                String am = String.valueOf(this.ammount.getString().substring(0, i)) + ".";
                String sf = this.ammount.getString().substring(i + 1);
                if (sf.length() < 2) {
                    int j = 0;
                    while (j < 2 - sf.length() + 1) {
                        sf = String.valueOf(sf) + "0";
                        ++j;
                    }
                }
                this.ammount.setString(String.valueOf(am) + sf);
            }
            Cash2ME.main.rms.writeRecord(this.ammount.getString());
            Cash2ME.main.rms.writeRecord(this.description.getString());
            Cash2ME.main.rms.closeRecStore();
            this.clear();
            Alert a = new Alert("Save", "Succesfully saved", Cash2ME.main.save, AlertType.INFO);
            a.setTimeout(-2);
            Cash2ME.display.setCurrent((Displayable)a);
        } else {
            Alert a = new Alert("Error", "Error while saving", Cash2ME.main.error, AlertType.ERROR);
            a.setTimeout(-2);
            Cash2ME.display.setCurrent((Displayable)a);
        }
    }

    public void load(String rec) {
        if (Cash2ME.main.rms.openRecStore(rec)) {
            this.date.setDate(new Date(Long.parseLong(Cash2ME.main.rms.readRecord(1))));
            this.categoryFrom.setSelectedIndex(Integer.parseInt(Cash2ME.main.rms.readRecord(3)), true);
            this.categoryTo.setSelectedIndex(Integer.parseInt(Cash2ME.main.rms.readRecord(5)), true);
            this.spendOrReceive.setSelectedIndex(Integer.parseInt(Cash2ME.main.rms.readRecord(7)), true);
            this.ammount.setString(Cash2ME.main.rms.readRecord(9));
            this.description.setString(Cash2ME.main.rms.readRecord(10));
            Cash2ME.main.rms.closeRecStore();
            this.curRec = rec;
        }
    }

    public void about() {
        Alert a = new Alert("About", "With Cash2ME you can keep track of your Expenses while you are on the road, and then sync up with your computer when you are back home.\n\nby S2\nhttp://cash2me.sf.net", Cash2ME.main.logo, AlertType.INFO);
        a.setTimeout(-2);
        Cash2ME.display.setCurrent((Displayable)a);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exit) {
            Cash2ME.main.exit();
        } else if (c == this.ok) {
            this.save();
        } else if (c == this.list) {
            Cash2ME.main.transactionList.setCurrent();
        } else if (c == this.categories) {
            Cash2ME.main.categories.setCurrent();
        } else if (c == this.about) {
            this.about();
        } else if (c == this.options) {
            Cash2ME.main.options.setCurrent();
        }
    }
}

