/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Rms {
    private RecordStore recStore = null;

    public String[] listRecStores() {
        int retLength = 0;
        String[] r = RecordStore.listRecordStores();
        retLength = r.length;
        if (this.recordStoreExists("options")) {
            --retLength;
        }
        if (this.recordStoreExists("categories")) {
            --retLength;
        }
        String[] ret = new String[retLength];
        int i = 0;
        int c = 0;
        while (i < r.length) {
            if (!r[i].equals("categories") && !r[i].equals("options")) {
                ret[c] = r[i];
            } else {
                --c;
            }
            ++i;
            ++c;
        }
        return ret;
    }

    public String[] listRecStoresAll() {
        return RecordStore.listRecordStores();
    }

    public String freeRecStoreName() {
        String[] r = RecordStore.listRecordStores();
        int c = 0;
        while (this.recordStoreExists(String.valueOf(c))) {
            ++c;
        }
        return String.valueOf(c);
    }

    public boolean recordStoreExists(String r) {
        String[] all = this.listRecStoresAll();
        int i = 0;
        while (i < all.length) {
            if (all[i].equals(r)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean deleteRecStore(String r) {
        try {
            RecordStore.deleteRecordStore((String)r);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public boolean openRecStore(String r) {
        try {
            this.recStore = RecordStore.openRecordStore((String)r, (boolean)true);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean closeRecStore() {
        try {
            this.recStore.closeRecordStore();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.recStore.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String readRecord(int id) {
        try {
            byte[] recData = new byte[this.recStore.getRecordSize(id)];
            int len = this.recStore.getRecord(id, recData, 0);
            return new String(recData, 0, len);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] readRecords() {
        String[] records = null;
        int i = 0;
        try {
            if (this.recStore.getNumRecords() > 0) {
                records = new String[this.recStore.getNumRecords()];
                SortCompare comp = new SortCompare();
                RecordEnumeration re = this.recStore.enumerateRecords(null, (RecordComparator)comp, false);
                while (re.hasNextElement()) {
                    String str;
                    records[i] = str = new String(re.nextRecord());
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return records;
    }

    public boolean deleteRecord(String id) {
        try {
            long recNum = this.readRecords().length;
            int i = 0;
            int c = 0;
            while ((long)i < recNum) {
                String rrec = this.readRecord(c);
                if (rrec != null) {
                    if (id.equals(rrec)) {
                        this.deleteRecord(c);
                        return true;
                    }
                } else {
                    --i;
                }
                ++i;
                ++c;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean deleteRecord(int id) {
        try {
            this.recStore.deleteRecord(id);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    class SortCompare
    implements RecordComparator {
        SortCompare() {
        }

        public int compare(byte[] rec1, byte[] rec2) {
            String str1 = new String(rec1);
            String str2 = new String(rec2);
            int result = str1.compareTo(str2);
            if (result == 0) {
                return 0;
            }
            if (result < 0) {
                return -1;
            }
            return 1;
        }
    }
}

