/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import telnet.Console;
import telnet.Dimension;
import telnet.MidletTerminal;
import telnet.TelnetProtocolHandler;
import telnet.vt320;

public class Telnet
extends MIDlet
implements Runnable {
    private static Telnet instance;
    public static vt320 emulation;
    public static TelnetProtocolHandler telnet;
    public static MidletTerminal terminal;
    public static Console console;
    private byte[] output = null;
    private int outputCount = 0;
    public static int traffic;
    public static int sleepTime;
    public static int keepAliveCycles;
    public static StreamConnection socket;
    private static DataInputStream in;
    private static DataOutputStream out;
    public static Thread reader;
    public static boolean useColors;
    public static String host;
    public static String port;

    public Telnet() {
        instance = this;
        this.output = new byte[64];
        useColors = this.getDisplay().isColor();
        emulation = new vt320(){

            public void write(byte[] byArray) {
                try {
                    if (Telnet.emulation.localecho) {
                        emulation.putString(new String(byArray));
                    }
                    telnet.transpose(byArray);
                }
                catch (IOException iOException) {
                    emulation.putString(iOException.getMessage());
                }
            }
        };
        terminal = new MidletTerminal(emulation);
        reader = new Thread(this);
        telnet = new TelnetProtocolHandler(){

            public String getTerminalType() {
                return emulation.getTerminalID();
            }

            public Dimension getWindowSize() {
                return new Dimension(emulation.getColumns(), emulation.getRows());
            }

            public void setLocalEcho(boolean bl) {
                Telnet.emulation.localecho = bl;
            }

            public void notifyEndOfRecord() {
            }

            public void write(byte[] byArray) throws IOException {
                if (Telnet.this.outputCount + byArray.length > Telnet.this.output.length) {
                    byte[] byArray2 = new byte[Telnet.this.outputCount + byArray.length];
                    System.arraycopy(Telnet.this.output, 0, byArray2, 0, Telnet.this.outputCount);
                    Telnet.access$102(Telnet.this, byArray2);
                }
                System.arraycopy(byArray, 0, Telnet.this.output, Telnet.this.outputCount, byArray.length);
                Telnet.this.outputCount += byArray.length;
            }
        };
    }

    public void startApp() {
        Telnet.setDisplay((Displayable)terminal);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public static void setDisplay(Displayable displayable) {
        instance.getDisplay().setCurrent(displayable);
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void run() {
        int n = 0;
        try {
            emulation.putString("Connecting...");
            terminal.redraw();
            socket = (StreamConnection)Connector.open((String)("socket://" + host + ":" + port), (int)3, (boolean)false);
            in = socket.openDataInputStream();
            out = socket.openDataOutputStream();
            emulation.putString("OK");
        }
        catch (Exception exception) {
            emulation.putString("FAILED");
        }
        emulation.putString("\n\r");
        terminal.redraw();
        try {
            while (true) {
                int n2;
                if ((n2 = in.available()) <= 0) {
                    if (this.outputCount > 0) {
                        console.append("Flushing output");
                        traffic += this.outputCount;
                        out.write(this.output, 0, this.outputCount);
                        this.outputCount = 0;
                        continue;
                    }
                    Thread.sleep(sleepTime);
                    if (n++ <= keepAliveCycles) continue;
                    emulation.keyTyped(0, 'a', 0);
                    emulation.keyPressed(8, '\b', 0);
                    n = 0;
                    continue;
                }
                console.append("Input:");
                byte[] byArray = new byte[n2];
                traffic += n2;
                in.read(byArray, 0, n2);
                console.append(new String(byArray));
                telnet.inputfeed(byArray, n2);
                do {
                    if ((n2 = telnet.negotiate(byArray)) <= 0) continue;
                    emulation.putString(new String(byArray, 0, n2));
                    terminal.redraw();
                } while (n2 != -1);
                n = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static /* synthetic */ byte[] access$102(Telnet telnet, byte[] byArray) {
        telnet.output = byArray;
        return byArray;
    }

    static {
        console = new Console();
        traffic = 0;
        sleepTime = 1000;
        keepAliveCycles = 300;
        useColors = true;
    }
}

