/*
 * Decompiled with CFR 0.152.
 */
package com.hakore.krzak.Fremtris;

import com.hakore.krzak.Fremtris.FremtrisColor;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FremtrisBlock {
    private int[][] block;
    private int pos_x = 0;
    private int pos_y = 0;
    private int width = 0;
    private int height = 0;
    private int color_code = 2;
    private byte[] b;
    private Image image = null;

    FremtrisBlock() {
    }

    FremtrisBlock(byte[] byArray, int n) {
        this.color_code = n;
        this.createBlock(0, 0, byArray);
    }

    FremtrisBlock(int n, byte[] byArray) {
        this.color_code = FremtrisColor.getRandomColor();
        this.createBlock(-1, n / 2, byArray);
    }

    FremtrisBlock(int n, int n2, byte[] byArray) {
        this.color_code = FremtrisColor.getRandomColor();
        this.createBlock(n, n2, byArray);
    }

    FremtrisBlock(int n, int n2, byte[] byArray, int n3) {
        this.color_code = n3;
        this.createBlock(n, n2, byArray);
    }

    public FremtrisBlock clone1() {
        FremtrisBlock fremtrisBlock = new FremtrisBlock();
        fremtrisBlock.block = this.block;
        fremtrisBlock.pos_x = this.getPositionX();
        fremtrisBlock.pos_y = this.getPositionY();
        fremtrisBlock.width = this.getWidth();
        fremtrisBlock.height = this.getHeight();
        fremtrisBlock.color_code = this.getColorCode();
        fremtrisBlock.b = this.b;
        return fremtrisBlock;
    }

    public void rotate() {
        int[][] nArray = new int[this.getHeight()][this.getWidth()];
        int n = this.getWidth();
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = this.getWidth() - 1; j >= 0; --j) {
                nArray[i][this.getWidth() - 1 - j] = this.block[j][i];
            }
        }
        this.width = this.getHeight();
        this.height = n;
        this.block = null;
        this.block = nArray;
    }

    public Image getImage(int n) {
        if (this.image != null) {
            return this.image;
        }
        this.image = Image.createImage((int)(this.getWidth() * n + 1), (int)(this.getHeight() * n + 1));
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(0xFFFFFF);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                if (this.getArray()[i][j] == 0) continue;
                graphics.setColor(0);
                graphics.drawRect(n * i, n * j, n, n);
                graphics.setColor(FremtrisColor.getColorRGB(this.color_code));
                graphics.fillRect(n * i + 1, n * j + 1, n - 1, n - 1);
            }
        }
        return this.image;
    }

    private void createBlock(int n, int n2, byte[] byArray) {
        int n3;
        int n4;
        int n5;
        for (n5 = 1; n5 >= 0; --n5) {
            n4 = 1;
            for (n3 = 0; n4 <= byArray.length * 8 && n3 < byArray.length * 8; n4 *= 2, ++n3) {
                if ((n4 & byArray[n5]) != n4) continue;
                if (n3 > this.width - 1) {
                    this.width = n3 + 1;
                }
                if (n5 <= this.height - 1) continue;
                this.height = n5 + 1;
            }
        }
        this.block = new int[this.width][this.height];
        for (n5 = 1; n5 >= 0; --n5) {
            n4 = 1;
            for (n3 = 0; n4 <= 8 && n3 < 4; n4 *= 2, ++n3) {
                if ((n4 & byArray[n5]) != n4) continue;
                this.block[n3][n5] = this.color_code;
            }
        }
        this.pos_x = n == -1 ? n2 - this.width / 2 : n;
        this.pos_y = n == -1 ? 0 : n2;
        this.b = byArray;
    }

    public int getPositionX() {
        return this.pos_x;
    }

    public int getPositionY() {
        return this.pos_y;
    }

    public void setPosition(int n, int n2) {
        this.pos_x = n;
        this.pos_y = n2;
    }

    public int[][] getArray() {
        return this.block;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColorCode() {
        return this.color_code;
    }
}

